"""

"""

# Created by Fanxing Liu <fanxingliu2020@gmail.com>
# License: BSD-3-Clause

ETT_h1 = {
    "Autoformer": {
        "n_steps": 48, 
        "n_features": 7, 
        "epochs": 100, 
        "patience": 10, 
        "n_layers": 2, 
        "d_model": 128, 
        "d_ffn": 64, 
        "n_heads": 1, 
        "factor": 3, 
        "moving_avg_window_size": 25, 
        "dropout": 0, 
        "lr": 0.0022868569237041655,
    },
    "BRITS": {
        "n_steps": 48, 
        "n_features": 7, 
        "patience": 10, 
        "epochs": 100, 
        "rnn_hidden_size": 512, 
        "lr": 0.005364156231811175,
    },
    "Crossformer": {
        "n_steps": 48, 
        "n_features": 7, 
        "epochs": 100, 
        "patience": 10, 
        "n_layers": 2, 
        "d_model": 64, 
        "d_ffn": 128, 
        "n_heads": 2, 
        "factor": 3, 
        "seg_len": 6, 
        "win_size": 2, 
        "dropout": 0.2, 
        "lr": 0.006541781103589732,
    },
    "CSDI": {
        "n_steps": 48, 
        "n_features": 7, 
        "patience": 10, 
        "epochs": 100, 
        "n_layers": 4, 
        "n_heads": 4, 
        "n_channels": 128, 
        "d_time_embedding": 128, 
        "d_feature_embedding": 16, 
        "d_diffusion_embedding": 128, 
        "lr": 0.0012659791476320047,
    },
    "DLinear": {
        "n_steps": 48, 
        "n_features": 7, 
        "epochs": 100, 
        "patience": 10, 
        "moving_avg_window_size": 13, 
        "d_model": 64, 
        "lr": 0.003881222990953312,
    },
    "ETSformer": {
        "n_steps": 48, 
        "n_features": 7, 
        "epochs": 100, 
        "patience": 10, 
        "n_e_layers": 3, 
        "n_d_layers": 3, 
        "d_model": 256, 
        "d_ffn": 256, 
        "n_heads": 1, 
        "top_k": 5, 
        "dropout": 0, 
        "lr": 0.0009222955773306727,
    },
    "FiLM": {
        "n_steps": 48, 
        "n_features": 7, 
        "epochs": 100, 
        "patience": 10, 
        "window_size": [2], 
        "multiscale": [1, 2], 
        "modes1": 32, 
        "dropout": 0.2, 
        "mode_type": 0, 
        "d_model": 512, 
        "lr": 0.007733843081398876,
    },
    "FreTS": {
        "n_steps": 48, 
        "n_features": 7, 
        "epochs": 100, 
        "patience": 10, 
        "embed_size": 128, 
        "hidden_size": 64, 
        "channel_independence": True, 
        "lr": 0.007511355522399692,
    },
    "GPVAE": {
        "n_steps": 48, 
        "n_features": 7, 
        "latent_size": 7, 
        "patience": 10, 
        "epochs": 100, 
        "lr": 0.006465674313955073, 
        "beta": 0.2, 
        "sigma": 1.005, 
        "length_scale": 7, 
        "encoder_sizes": [256, 256], 
        "decoder_sizes": [512, 512], 
        "window_size": 24,
    },
    "GRUD": {
        "n_steps": 48, 
        "n_features": 7, 
        "epochs": 100, 
        "patience": 10, 
        "rnn_hidden_size": 256, 
        "lr": 0.0024808268864150835,
    },
    "Informer": {
        "n_steps": 48, 
        "n_features": 7, 
        "epochs": 100, 
        "patience": 10, 
        "n_layers": 2, 
        "d_model": 256, 
        "d_ffn": 512, 
        "n_heads": 1, 
        "factor": 5, 
        "dropout": 0, 
        "lr": 0.0006451237772559212,
    },
    "iTransformer": {
        "n_steps": 48, 
        "n_features": 7, 
        "epochs": 100, 
        "patience": 10, 
        "n_layers": 5, 
        "d_model": 256, 
        "d_ffn": 1024, 
        "n_heads": 8, 
        "d_k": 128, 
        "d_v": 32, 
        "dropout": 0, 
        "attn_dropout": 0.1, 
        "lr": 5.03298011103654e-05,
    },
    "Koopa": {
        "n_steps": 48, 
        "n_features": 7, 
        "epochs": 100, 
        "patience": 10, 
        "n_seg_steps": 12, 
        "d_dynamic": 128, 
        "d_hidden": 512, 
        "n_hidden_layers": 1, 
        "n_blocks": 4, 
        "lr": 0.009615515635277004,
    },
    "MICN": {
        "n_steps": 48, 
        "n_features": 7, 
        "epochs": 100, 
        "patience": 10, 
        "n_layers": 2, 
        "d_model": 128, 
        "conv_kernel": [2, 4], 
        "dropout": 0.1, 
        "lr": 0.0016323276726771972,
    },
    "MRNN": {
        "n_steps": 48, 
        "n_features": 7, 
        "patience": 10, 
        "epochs": 100, 
        "rnn_hidden_size": 16, 
        "lr": 0.004064028157045359,
    },
    "NonstationaryTransformer": {
        "n_steps": 48, 
        "n_features": 7, 
        "epochs": 100, 
        "patience": 10, 
        "n_layers": 1, 
        "d_model": 64, 
        "n_heads": 4, 
        "d_ffn": 4096, 
        "n_projector_hidden_layers": 2, 
        "d_projector_hidden": [128, 128], 
        "dropout": 0.1, 
        "lr": 0.00519740553820383,
    },
    "PatchTST": {
        "n_steps": 48, 
        "n_features": 7, 
        "epochs": 100, 
        "patience": 10, 
        "patch_len": 8, 
        "stride": 2, 
        "n_layers": 2, 
        "d_model": 64, 
        "d_ffn": 128, 
        "n_heads": 1, 
        "d_k": 32, 
        "d_v": 128, 
        "dropout": 0.1, 
        "attn_dropout": 0, 
        "lr": 0.007985520527092456,
    },
    "Pyraformer": {
        "n_steps": 48, 
        "n_features": 7, 
        "epochs": 100, 
        "patience": 10, 
        "n_layers": 3, 
        "d_model": 1024, 
        "d_ffn": 256, 
        "n_heads": 4, 
        "window_size": [4, 4], 
        "inner_size": 3, 
        "dropout": 0, 
        "attn_dropout": 0.4, 
        "lr": 0.00022218931125454747,
    },
    "SAITS": {
        "n_steps": 48, 
        "n_features": 7, 
        "epochs": 100, 
        "patience": 10, 
        "n_layers": 3, 
        "d_model": 64, 
        "d_ffn": 512, 
        "n_heads": 8, 
        "d_k": 256, 
        "d_v": 128, 
        "dropout": 0, 
        "attn_dropout": 0.1, 
        "lr": 0.00013619330183926336,
    },
    "SCINet": {
        "n_steps": 48, 
        "n_features": 7, 
        "epochs": 100, 
        "patience": 10, 
        "n_stacks": 1, 
        "n_levels": 1, 
        "n_groups": 1, 
        "n_decoder_layers": 1, 
        "d_hidden": 64, 
        "dropout": 0, 
        "lr": 0.008305151767546358,
    },
    "StemGNN": {
        "n_steps": 48, 
        "n_features": 7, 
        "epochs": 100, 
        "patience": 10, 
        "n_layers": 2, 
        "n_stacks": 2, 
        "d_model": 1024, 
        "dropout": 0.1, 
        "lr": 0.0025092583072368864,
    },
    "TimesNet": {
        "n_steps": 48, 
        "n_features": 7, 
        "patience": 10, 
        "epochs": 100, 
        "n_layers": 1, 
        "top_k": 1, 
        "d_model": 128, 
        "d_ffn": 256, 
        "n_kernels": 4, 
        "dropout": 0.1, 
        "lr": 0.0004496195292510804,
    },
    "Transformer": {
        "n_steps": 48, 
        "n_features": 7, 
        "epochs": 100, 
        "patience": 10, 
        "n_layers": 2, 
        "d_model": 128, 
        "d_ffn": 128, 
        "n_heads": 2, 
        "d_k": 512, 
        "d_v": 128, 
        "dropout": 0.2, 
        "attn_dropout": 0.1, 
        "lr": 0.0008333763231640121,
    },
    "USGAN": {
        "n_steps": 48, 
        "n_features": 7, 
        "patience": 10, 
        "epochs": 100, 
        "lr": 0.009769718248164798, 
        "rnn_hidden_size": 512, 
        "dropout": 0.4,
    },
}
